export type AdminRole = 'super_admin' | 'admin' | 'moderator';
export type AdminPermission = 'view_kyc' | 'edit_settings' | 'manage_plans' | 'approve_kyc' | 'impersonate' | 'view_logs' | 'resolve_tickets' | 'custom';

export interface Admin {
  id: string;
  email: string;
  role: AdminRole;
  permissions: AdminPermission[];
  created_at: string;
  updated_at: string;
}

export interface AdminSettings {
  withdrawal_interval: 'weekly' | 'monthly';
  fee_percentage: number;
  kyc_required_threshold: number;
  default_currency: string;
  referral_bonus: number;
  [key: string]: any;
}

export interface FeatureFlags {
  [key: string]: boolean;
}

export interface SupportTicket {
  id: string;
  user_id: string;
  subject: string;
  status: 'open' | 'resolved' | 'closed';
  messages: Array<{ sender: string; message: string; created_at: string }>;
  created_at: string;
  updated_at: string;
}

export interface AdminLog {
  id: string;
  admin_id: string;
  action: string;
  target_id?: string;
  details?: string;
  created_at: string;
}

export interface CreateAdminRequest {
  email: string;
  role: AdminRole;
  permissions: AdminPermission[];
}

export interface UpdateAdminPermissionsRequest {
  permissions: AdminPermission[];
}

export interface UpdateSettingsRequest {
  [key: string]: any;
}

export interface UpdateFeatureFlagsRequest {
  [key: string]: boolean;
}

export interface ImpersonateRequest {
  user_id: string;
}

export interface UpdateSupportTicketRequest {
  status?: 'resolved' | 'closed';
  message?: string;
} 